/* 
 * getopt_long.c 
 *
 * Обробляє аргументи за допомогою функції getopt_long().
 * Ілюструє порядок обробки опцій програми.
 *
 */

#include <getopt.h>
#include <stdio.h>
#include <stdlib.h>

/* Ім'я програми */
char* program_name; 

/* Виводить інформацію про порядок запуску програми в потік stream
   і завершує роботу, повертаючи код exit_code. */
void print_usage(FILE* stream, int exit_code)
{
        fprintf(stream, "Usage: %s options [ input_file ... ]\n",
                                                        program_name);
        fprintf(stream, 
                " -h --help                 Display this usage information.\n"
                " -o --output filename      Write output to file.\n"
                " -v --verbose              Print verbose messages.\n");
        exit(exit_code);
}

int main(int argc, char* argv[])
{
        int nextopt;
        /* Рядок з описом можливих коротких опцій */
        const char* short_options = "ho:v";
        /* Масив з описом можливих довгих опцій */
        const struct option long_options[] = {
                {"help",	no_argument,       NULL, 'h'},
                {"output",	required_argument, NULL, 'o'},
                {"verbose",	no_argument,       NULL, 'v'},
                /* Повинно бути в кінці масиву */
                {NULL,		no_argument,       NULL, 0}
        };
        /* Ім'я файлу, в який записуються результати роботи 
           (якщо NULL - виведення спрямовується в потік stdout) */
        const char* output_filename = NULL;
        /* Перемикач говірливості */
        int verbose = 0;
    
        /* Запам'ятовує ім'я програми в змінній program_name */
        program_name = argv[0];

        /* Обробляє опції. */    
        do {
                nextopt = getopt_long(argc, argv, 
                                        short_options, long_options, NULL);
                switch (nextopt) {
                case 'h':       /* -h або --help */
                        /* Користувач лише запитав інформацію про порядок
                           запуску програми. Треба вивести цю інформацію в
                           потік stdout і завершити роботу з видачею 
                           коду EXIT_SUCCESS (нормальне завершення). */
                        print_usage(stdout, EXIT_SUCCESS);
                        break;
                case 'o':       /* -o або --output */    
                        /* Ця опція приймає аргумент - ім'я
                           результуючого файлу */
                        output_filename = optarg;
                        break;
                case 'v':       /* -v або --verbose */    
                        verbose = 1;
                        break;
                case '?':       /* Неправильна опція */    
                        /* Виводить інформацію про порядок запуску
                           програми в потік stderr і завершує роботу з
                           видачею коду EXIT_FAILURE
                           (аварійне завершення). */
                        print_usage(stderr, EXIT_FAILURE);   
                        break;
                case -1:        /* Опцій більше немає */
                        break;
                default:        /* Якийсь непередбачений результат */
                        abort();
                }    
        } while (nextopt != -1);

        /* Обробка опцій завершена. Змінна optind указує на
           перший аргумент, що не є опцією. В демонстраційних цілях
           ці аргументи виводяться, якщо заданий режим verbose. */
        if (verbose) {
                int i;

                for (i = optind; i < argc; ++i)
                        printf("Argument: %s\n", argv[i]);
        }
    
        /* Далі йде основне тіло програми... */

    exit(EXIT_SUCCESS);
}
